%\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{aseg2026}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%define some formatting information
%relevant to aseg2026.tex
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\LoadClass[10pt]{extarticle}
\RequirePackage{titlesec} % to define formats for headings using command \titleformat
\RequirePackage{fancyhdr} % used to define custom headers and footers
\RequirePackage{graphicx} % to include graphics
\RequirePackage{tabularx} % to create author table 
\RequirePackage{natbib} % handles .bib bibliography
\RequirePackage{calc} % allows performing calculations e.g. \linewidth-2\fboxsep below

% setup page layout
\RequirePackage{geometry}
 \geometry{
 a4paper,
 textwidth = 170mm,
 headheight = 15mm, 
 top=25mm,
 bottom = 27.5mm,
 headsep = 10mm,
 footskip = 10mm
 }

%Format for titles
\newcommand{\asegtitle}[1]{\begin{center}{\textbf{#1}}\end{center}}
\newcommand{\asegminortitle}[1]{\textbf{#1}}
\usepackage{array,supertabular,hhline}


  % paragraph formatting
\setlength\parindent{0pt}
\setlength{\parskip}{1em}


%  Define section heading format
\titleformat{\section}[hang]{\bfseries\fontsize{10}{12}\selectfont}{}{0pt}{\centering\MakeUppercase}
\titlespacing*{\section}{0pt}{*0}{*0}


% set default font size
\renewcommand{\normalsize}{\fontsize{9}{10}\selectfont}

% remove header line
\renewcommand{\headrulewidth}{0pt}

% set style for title page
\fancypagestyle{ttlpage}{
  \fancyhf{}
  \rhead{{\includegraphics[width=3cm]{aseg2026_logo.png}}}
    \lfoot{\sffamily\bfseries\itshape
      2\textsuperscript{nd} ASEG DISCOVER Symposium 2026: 26-30 October 2026, Cairns, Australia}

    \rfoot{\sffamily\bfseries\itshape\thepage}
}

% set style for normal pages
\fancypagestyle{main}{
  \fancyhf{}
  \lhead{\sffamily\itshape Abbreviated Title }
  \rhead{\sffamily\itshape Author1, Author2, Author3} %if too many use Author1 et al.
  \lfoot{\sffamily\bfseries\itshape
    2\textsuperscript{nd} ASEG DISCOVER Symposium 2026: 26-30 October 2026, Cairns, Australia}
\rfoot{\sffamily\bfseries\itshape\thepage}
}



\newcommand{\abstractTitle}[1]{{\bigskip\noindent\sffamily\fontsize{16}{18.2}\selectfont \\ \\ #1}}

\newcommand{\summary}[1]{{\setlength{\fboxsep}{6pt}\noindent\fbox{\parbox{\linewidth-2\fboxsep}{
        \asegtitle{SUMMARY} 

        #1 }}}}

\newcommand{\abstractAuthor}[3]{
\begin{tabularx}{\textwidth}{
@{\raggedright\arraybackslash}X
}{\sffamily\bfseries#1} \\
    \sffamily\fontsize{8}{9.6}\selectfont\textit{#2} \\
    \sffamily\fontsize{8}{9.6}\selectfont\textit{#3} \\
   \end{tabularx}
}
